// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Peter Van Demark - Caliper Corporation - December 2001

    // This macro marks as duplicates any records that have the same value in
    // a field as the first record with that value.

    // The macro illustrates how to:
    // 1. Loop over the records in sorted order.
    // 2. Read a value from a field.
    // 3. Find the first record in a group.
    // 4. Write a value to a field.

    // You can modify the macro to use a dialog box to get the values for the
    // input variables, mark members of a group with a counter (1, 2, 3, etc.),
    // add the duplicates to a selection set, etc.

    // To run this macro using the GISDK toolbox:
    // 1. Open the table that you want to use and get the name of the dataview.
    // 2. Edit the initialization section to set the values of the variables,
    //    and save the changes.
    // 3. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 4. Compile this macro in test mode using the first button (Compile).
    // 5. Run this macro by clicking the second button (Test), typing the macro 
    //    name "Mark Duplicates", clicking the Macro radio button, and clicking OK.

Macro "Mark Duplicates"
// Initialize input variables
    input_table = "xxx"    //Name of table
    selection_set = "xxx"  //Name of selection set
    group = "xxx"          //Name of field that defines groups
    dupl_field = "xxx"     //Name of field to fill for duplicates
    dupl_value = "x"       //Value to fill into field

// Initialize tracking variable
    last_group = null

// Loop over records and mark second, etc. records within group
    rec = GetFirstRecord(input_table + "|" + selection_set, {{group, "Ascending"}})
    while rec <> null do
        // See if a new group is starting
        if input_table.(group) <> last_group
            // Yes. Read the group code into the tracking variable
            then last_group = input_table.(group)
            // No. Write the fill value into the duplicate field
            else input_table.(dupl_field) = dupl_value           
        rec = GetNextRecord(input_table + "|" + selection_set, rec, {{group, "Ascending"}})
        end

endMacro
